# __init__.py
import bpy
from .moqap import (
    register as bvh_register,
    unregister as bvh_unregister
)

bl_info = {
    "name": "MoqapLens",
    "blender": (4, 1, 0),
    "category": "3DMotaas",
    "version": (1, 1, 2),
    "author": "Algolysis Ltd.",
    "description": "Import BVH files into Blender and process via API",
    "location": "View3D > Sidebar > MoqapLens",
}


class BVHAddonPreferences(bpy.types.AddonPreferences):
    bl_idname = __name__

    api_endpoint: bpy.props.StringProperty(
        name="API Endpoint",
        description="HTTPS endpoint for BVH retargeting",
        default="https://search.moqap.eu/retarget"
    )
    api_key: bpy.props.StringProperty(
        name="API Key (optional)",
        description="If your API requires a bearer token; stored in the blend file prefs",
        default="",
        subtype='PASSWORD'
    )

    def draw(self, context):
        layout = self.layout
        layout.prop(self, "api_endpoint")
        layout.prop(self, "api_key")


def register():
    bpy.utils.register_class(BVHAddonPreferences)
    bvh_register()


def unregister():
    bvh_unregister()
    bpy.utils.unregister_class(BVHAddonPreferences)
